<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;
    
    public $timestamps = false; // Disable timestamps

    protected $fillable = ['department_name', 'status', 'date_added', 'date_updated']; // Fillable fields

    public function indicators()
    {
        return $this->hasMany(Indicator::class);
    }

    public function user()
    {
        return $this->hasMany(User::class);
    }
}
