<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class UserCreatedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $user;
    public $url;
    public $password;

    public function __construct($user, $password)
    {
        $this->user = $user;
        $this->password = $password;
        $this->url = route('indicator_data_entries');
    }

    public function build()
    {
        return $this->subject('J&K - SDG: Your Account Has Been Created')
                    ->markdown('emails.user_created');
    }
}
