<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DepartmentHODRejectionMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $user;
    public $reason;
    public $indicatorDataEntry;
    public $data_added_by_user;
    public $url;

    public function __construct($user, $data_added_by_user, $indicatorDataEntry, $reason)
    {
        $this->user = $user;
        $this->data_added_by_user = $data_added_by_user;
        $this->indicatorDataEntry = $indicatorDataEntry;
        $this->reason = $reason;
        $this->url = route('indicator_data_entries');
    }

    public function build()
    {
        return $this->subject('J&K - SDG: Data Entry Rejection Notification')
                    ->markdown('emails.department_hod_rejection');
    }
}
