<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ApprovalNotificationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;
    public $user, $level, $next, $indicatorDataEntry, $url;

    public function __construct($user, $level, $next,$indicatorDataEntry) {
        $this->user = $user;
        $this->level = $level;
        $this->next = $next;
        $this->indicatorDataEntry = $indicatorDataEntry;
        $this->url = route('indicator_data_entries');
    }

    public function build() {
        return $this->subject("J&K - SDG: Submission Approved at $this->level Level")
                    ->markdown('emails.approval_notification');
    }
}

