<?php

namespace App\Listeners;

use Illuminate\Queue\Events\JobFailed;
use Illuminate\Support\Facades\Notification;
use App\Notifications\JobFailedNotification as JobFailedNotificationMessage;

class JobFailedNotification
{
    public function handle(JobFailed $event)
    {
        // Define recipient, e.g., a specific user or an admin email
        $recipient = config('app.notification_email');

        // Send notification
        Notification::route('mail', $recipient) // For email notification
            ->notify(new JobFailedNotificationMessage($event));
    }
}
