<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Cache;
use App\Events\JobCompletedEvent;

class NotifyCompletionJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $batchId;
    protected $count;

    public function __construct($batchId, $count)
    {
        $this->batchId = $batchId;
        $this->count = $count;
    }

    public function handle()
    {
        // Decrement the counter
        $remaining = Cache::decrement($this->batchId); // Corrected line

        // If all chunks are processed
        if ($remaining <= 0) {
            $jobName = 'UNDP-SDG-J&K: Run Stored Procedures';
            $i = 2000; // Total indicators processed, adjust as needed
            event(new JobCompletedEvent($jobName, $this->count));

            // Optionally, clean up the cache
            Cache::forget($this->batchId); // Corrected line
        }
    }
}
