<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckSession
{
    public function handle(Request $request, Closure $next)
    {
        // Check if the user is authenticated
        if (Auth::check()) {
            $user = Auth::user();
            
            // Retrieve the custom session ID from the session
            $currentSessionId = session('custom_session_id');
            
            // Compare the custom session ID stored in the database with the session ID
            if ($user->session_id !== $currentSessionId) {
                // If they don't match, log out the user
                Auth::logout();
                $request->session()->invalidate();
                $request->session()->regenerateToken();

                // Redirect to login page with an error message
                return redirect()->route('login')->withErrors(['email' => 'Your session is expired.']);
            }
        }

        return $next($request);
    }
}

