<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class BlockUnwantedMethods
{
    // List of unwanted HTTP methods
    protected $unwantedMethods = ['OPTIONS', 'TRACE', 'DELETE'];

    public function handle($request, Closure $next)
    {
        // Check if the request method is in the unwanted methods list
        if (in_array($request->method(), $this->unwantedMethods)) {
            // Return a 405 Method Not Allowed response
            return response('Method Not Allowed', 405);
        }

        return $next($request);
    }
}
