<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:View Permission', ['only' => ['index']]);
        $this->middleware('permission:Create Permission', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update Permission', ['only' => ['update', 'edit']]);
        $this->middleware('permission:Delete Permission', ['only' => ['destroy']]);
        $this->middleware('auth');
    }

    public function index()
    {
        $permissions = Permission::get();
        return view('admin_pages.access-control.permission.index', ['permissions' => $permissions]);
    }

    public function create()
    {
        $query = Permission::query();
        $query->distinct()->select('module_name');
        $module = $query->get();
        return view('admin_pages.access-control.permission.create', ['modules'=>$module]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => [
                'required',
                'string',
                'unique:permissions,name'
            ],
            'module'=>[
                'required',
                'string'
            ]
        ]);

        Permission::create([
            'name' => $request->name,
            'module_name'=>$request->module,
        ]);

        return redirect('permissions')->with('status', 'Permission Created Successfully');
    }

    public function edit(Permission $permission)
    {
        $query = Permission::query();
        $query->distinct()->select('module_name');
        $module = $query->get();
        return view('admin_pages.access-control.permission.edit', ['permission' => $permission, 'modules'=>$module]);
    }

    public function update(Request $request, Permission $permission)
    {
        $request->validate([
            'name' => [
                'required',
                'string',
                'unique:permissions,name,' . $permission->id
            ],
            'module' => [
                'required',
                'string'
            ]
        ]);

        $permission->update([
            'name' => $request->name,
            'module_name'=> $request->module
        ]);

        return redirect('permissions')->with('status', 'Permission Updated Successfully');
    }

    public function destroy($permissionId)
    {
        $permission = Permission::find($permissionId);
        $permission->delete();
        return redirect('permissions')->with('status', 'Permission Deleted Successfully');
    }
}
