<?php


// BOC
// Task #156544 The Comparison on SDG India Index section should display a detailed comparison of SDG scores with other states.
// This controller is used to load data on the admin dashboard for the input of the comparison data. This controller controller contains two functions index and store and update.
// @author Almaaz Ahmed
// @date 18-12-2024
    
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Helpers\CommonHelper;
use App\Helpers\PublicPageHelper;
use App\Models\GoalComparisionWithIndia;
use App\Models\ReportingYear;
use App\Models\BlockGeographicalDetail;
use App\Models\Innovation;
use App\Models\UpcomingEvent;
use App\Models\State;
use App\Models\Gallery;
use Illuminate\Http\Request;
use App\Models\Goal;
use Illuminate\Database\QueryException;

class DashboardInputController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:View Dashboard-Input', ['only' => ['index']]);
        $this->middleware('permission:Edit Dashboard-Input', ['only' => ['saveOrUpdate']]);
        $this->middleware('auth');
    }
    
    public function index()
    {
        try{
            $allGoals = Goal::all();
        }catch(QueryException $e){
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
        }
        
        $default_year = app('defaultYear');
        // Updated the below code so to get all the years from the reporting year table
        $allYears = ReportingYear::query();
        try{
            $allYears = $allYears->select('id','reporting_year','reporting_year_base')->where('status', 'Active')->get();
        }catch(QueryException $e){
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
        }

        if (!$allYears) {
            $allYears = [];
        }

        $query = State::query();
        try{
            $allStates = $query->where('status', 'Active')->where('is_ut', 'No')->get();
        }catch(QueryException $e){
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
        }
        
        if (!$allStates) {
            $allStates = [];
        }

        $allUts = State::query();
        try{
            $allUts = $allUts->where('status', 'Active')->where('is_ut', 'Yes')->get();
        }catch(QueryException $e){
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
        }
        return view('admin_pages.dashboard_input.index', compact('allYears', 'allStates', 'allGoals','default_year','allUts'));
    }

    public function saveOrUpdate(Request $request)
    {
        // Validate the request
        $request->validate([
            'goal_id' => 'required', // Assuming `goal_id` is passed as input
            'dashboard_input_goal_year' => 'required', // Assuming year_id is passed as input
            'india_score' => 'required|numeric|min:0|max:100',
            'bestPerformingState' => 'required|string',
            'best_state_score' => 'required|numeric|min:0|max:100',
            'bestPerformingUT' => 'required|string',
            'best_ut_score' => 'required|numeric|min:0|max:100',
            'jammu_and_kashmir_score' => 'required|numeric|min:0|max:100',
        ]);

        if(isset($request->bestPerformingState) && $request->bestPerformingState !=""){
            try{
                $state = State::where('state_name', $request->bestPerformingState)->first();
            }catch(QueryException $e){
                $logData['file'] = __FILE__;
                $logData['method'] = __FUNCTION__;
                $logData['query'] = $e->getSql();
                $logData['exception'] = $e->getMessage();
                // Log exception to file with file name and method information
                CommonHelper::dataActionLogger($logData, 'exception');
            }
            if(isset($state->state_id)){
                $bestPerformingState = $state->state_id;
            }
        }else{
            $bestPerformingState = NULL;
        }   

        if(isset($request->bestPerformingUT) && $request->bestPerformingUT !=""){
            try{
                $state = State::where('state_name', $request->bestPerformingUT)->first();
            }catch(QueryException $e){
                $logData['file'] = __FILE__;
                $logData['method'] = __FUNCTION__;
                $logData['query'] = $e->getSql();
                $logData['exception'] = $e->getMessage();
                // Log exception to file with file name and method information
                CommonHelper::dataActionLogger($logData, 'exception');
            }
            
            if(isset($state->state_id)){
                $bestPerformingUT = $state->state_id;
            }
        }
        else{
            $bestPerformingUT = NULL;
        }    

        
        if(isset($request->dashboard_input_goal_year) && $request->dashboard_input_goal_year !=""){
            try{
                $year = ReportingYear::where('id', $request->dashboard_input_goal_year)->first();
            }catch(QueryException $e){
                $logData['file'] = __FILE__;
                $logData['method'] = __FUNCTION__;
                $logData['query'] = $e->getSql();
                $logData['exception'] = $e->getMessage();
                // Log exception to file with file name and method information
                CommonHelper::dataActionLogger($logData, 'exception');
            }
            
            if(isset($year->reporting_year) && isset($year->id)){
                $yearId = $year->id;
                $year = $year->reporting_year;
            } 
        }

        // Determine Mizoram's category based on score
        if ($request->jammu_and_kashmir_score == 100) {
            $jammu_and_kashmir_category = "Achiever";
        } elseif ($request->jammu_and_kashmir_score >= 65) {
            $jammu_and_kashmir_category = "Front Runner";
        } elseif ($request->jammu_and_kashmir_score >= 50) {
            $jammu_and_kashmir_category = "Performer";
        } elseif ($request->jammu_and_kashmir_score >= 0) {
            $jammu_and_kashmir_category = "Aspirant";
        } else {
            $jammu_and_kashmir_category = "Information Unavailable";
        }
        
        $goal_id = $request->goal_id === 'all' ? null : $request->goal_id;

        // Check if an entry exists for the given goal_id and reporting_year_id
        try{
            $existingRecord = GoalComparisionWithIndia::where('goal_id', $goal_id)
            ->where('reporting_year_id', $yearId)
            ->first();
        }catch(QueryException $e){
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
        }
        

        try{
            if ($existingRecord) {
                // Update the existing record
                $existingRecord->update([
                    'india_score' => $request->india_score,
                    'best_performer_state' => $bestPerformingState,
                    'best_performer_state_score' => $request->best_state_score,
                    'jammu_and_kashmir_score' => $request->jammu_and_kashmir_score,
                    'jammu_and_kashmir_category' => $jammu_and_kashmir_category,
                    'best_performer_ut' => $bestPerformingUT,
                    'best_performer_ut_score' => $request->best_ut_score,
                    // Additional fields if any
                ]);
            } else {
                if($request->goal_id === 'all'){
                    // Create a new record
                    GoalComparisionWithIndia::create([
                        'reporting_year_id' => $yearId,
                        'reporting_year' => $year,
                        'india_score' => $request->india_score,
                        'best_performer_state' => $bestPerformingState,
                        'best_performer_state_score' => $request->best_state_score,
                        'jammu_and_kashmir_score' => $request->jammu_and_kashmir_score,
                        'jammu_and_kashmir_category' => $jammu_and_kashmir_category,
                        'best_performer_ut' => $bestPerformingUT,
                        'best_performer_ut_score' => $request->best_ut_score,
                        // Additional fields if any
                    ]);
                }else{
                    // Create a new record
                    GoalComparisionWithIndia::create([
                        'goal_id' => $request->goal_id ,
                        'reporting_year_id' => $yearId,
                        'reporting_year' => $year,
                        'india_score' => $request->india_score,
                        'best_performer_state' => $bestPerformingState,
                        'best_performer_state_score' => $request->best_state_score,
                        'jammu_and_kashmir_score' => $request->jammu_and_kashmir_score,
                        'jammu_and_kashmir_category' => $jammu_and_kashmir_category,
                        'best_performer_ut' => $bestPerformingUT,
                        'best_performer_ut_score' => $request->best_ut_score,
                        // Additional fields if any
                    ]);
                }
            }
        }catch(QueryException $e){
            $logData['file'] = __FILE__;
            $logData['method'] = __FUNCTION__;
            $logData['query'] = $e->getSql();
            $logData['exception'] = $e->getMessage();
            // Log exception to file with file name and method information
            CommonHelper::dataActionLogger($logData, 'exception');
        }
        

        // Redirect or respond as necessary
        return redirect()->route('dashboard_input')->with('success', 'Data saved successfully.');
    }

}
