<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;

class IndicatorDataEntryTemplate implements FromCollection, WithHeadings, WithStyles
{
    protected $indicators;

    public function __construct($indicators)
    {
        $this->indicators = $indicators;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return $this->indicators->map(function ($item, $key) {
            // Ensure the object only contains the columns you want to export
            return [
                'indicator_data_entries_id' => $item->indicator_data_entries_id,
                'indicator_id' => $item->indicator_id,
                'indicator_number' => $item->indicator_number,
                'indicator_name' => $item->indicator_name,
                'unit' => $item->unit,
                'is_utif' => $item->is_utif == 'yes' ? 'UTIF' : ($item->is_dif == 'Yes' ? 'DIF' : ''),
                'marker' => $item->is_positive_indicator,
                'value_type' => $item->value_type,
                'district_name' => $item->district_name,
                'department_name' => $item->department_name,
                'baseline_year' => $item->baseline_year,
                'baseline_value'=> $item->baseline_value,
                'target_value' => $item->target_value,
                'indicator_value' => $item->indicator_value,
                'status' => $item->status,
                'variance_status' => ''
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Indicator Data Entries ID',
            'Indicator ID',
            'Indicator Number',
            'Indicator Name',
            'Unit',
            'Indicator Type',
            'Indicator Marker',
            'Value Type',
            'District',
            'Department',
            'Baseline Year',
            'Baseline Value',
            'Target 2030',
            'Data Value (Current year)',
            'Status',
            'Variance Status'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $styleArray = [
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ];

        $highestRow = $sheet->getHighestRow();
        $highestColumn = $sheet->getHighestColumn();

        $sheet->getStyle('A1:' . $highestColumn . '1')->getFont()->setBold(true);
        $sheet->getStyle('A1:' . $highestColumn . $highestRow)->applyFromArray($styleArray);

        return [
            1 => ['fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => 'FFFF00']]],
        ];
    }
}
