<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class DepartmentExport implements FromCollection, WithHeadings
{
    protected $departments;

    public function __construct($departments)
    {
        $this->departments = $departments;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return $this->departments;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Department Name',
            'status',
            'created_at',
            'updated_at'
        ];
    }
}
